////////////////////////////////////////////////////////////////////////////////
//BFFSounds
//
//This class does nothing but load configurable sounds
////////////////////////////////////////////////////////////////////////////////
class DFFM extends Actor config(DanishSpawnProtect);

var	config	string
			ValidHit[10],			//hit sound for valid shots
			SpawnStart[10],			//start of spawn protection
			SpawnEnd[10],			//end of spawn protection
			HeadShot[10],			//head shot
			SameTeam[10],			//shooting teammate
			SpawnerShooterInit[10],	//shooting a spawner, first shot
			SpawnerShooterSubs[10],	//shooting a spawner, more shots in penalty
			SpawnerShooterDie[10],	//shooting a spawner, die
			SpawnShooterInit[10],	//shooting while spawning
			SpawnShooterSubs[10],	//shooting while spawning
			SpawnShooterDie[10],	//shooting while spawning
			SpawnSound;				//repeating sound during spawn period

//SOUND ARRAYS FOR THE ABOVE SOUND STRING ARRAYS
var	sound
			sndValidHit[10],
			sndSpawnStart[10],
			sndSpawnEnd[10],
			sndHeadShot[10],
			sndSameTeam[10],
			sndSpawnerShooterInit[10],
			sndSpawnerShooterSubs[10],
			sndSpawnerShooterDie[10],
			sndSpawnShooterInit[10],
			sndSpawnShooterSubs[10],
			sndSpawnShooterDie[10],
			sndSpawnSound;

var	int		sndHeadShotSize;

//HERE WE'LL TRY TO LOAD CONFIG SOUNDS AND WARN IF UNSUCCESSFUL
function LoadSounds()
{
	local	int		i,j;
	local	sound	mysound;

	//use i to track position in string array, j to track position in sound
	//array. goal is to not have all valid sounds at the beginning of the array
	//so that we can loop through them using a "it_int!=none" qualification
	//and not exit the loop too early.

	j=0;
	for(i=0; i<ArrayCount(ValidHit); i++)
	{
		if(ValidHit[i]!="")
		{
			mysound=sound(DynamicLoadObject(ValidHit[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$ValidHit[i]);
			else
			{
				sndValidHit[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnStart); i++)
	{
		if(SpawnStart[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnStart[i],class'Sound',false));
			if(mysound==none)
				log("## DFF - Error Loading Sound"$SpawnStart[i]);
			else
			{
				sndSpawnStart[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnEnd); i++)
	{
		if(SpawnEnd[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnEnd[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnEnd[i]);
			else
			{
				sndSpawnEnd[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(HeadShot); i++)
	{
		if(HeadShot[i]!="")
		{
			mysound=sound(DynamicLoadObject(HeadShot[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$HeadShot[i]);
			else
			{
				sndHeadShot[i]=mysound;
				j++;
			}
		}
	}
	sndHeadShotSize=j;

	j=0;
	for(i=0; i<ArrayCount(SameTeam); i++)
	{
		if(SameTeam[i]!="")
		{
			mysound=sound(DynamicLoadObject(SameTeam[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SameTeam[i]);
			else
			{
				sndSameTeam[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnerShooterInit); i++)
	{
		if(SpawnerShooterInit[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnerShooterInit[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnerShooterInit[i]);
			else
			{
				sndSpawnerShooterInit[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnerShooterSubs); i++)
	{
		if(SpawnerShooterSubs[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnerShooterSubs[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnerShooterSubs[i]);
			else
			{
				sndSpawnerShooterSubs[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnerShooterDie); i++)
	{
		if(SpawnerShooterDie[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnerShooterDie[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnerShooterDie[i]);
			else
			{
				sndSpawnerShooterDie[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnShooterInit); i++)
	{
		if(SpawnShooterInit[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnShooterInit[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnShooterInit[i]);
			else
			{
				sndSpawnShooterInit[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnShooterSubs); i++)
	{
		if(SpawnShooterSubs[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnShooterSubs[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnShooterSubs[i]);
			else
			{
				sndSpawnShooterSubs[i]=mysound;
				j++;
			}
		}
	}

	j=0;
	for(i=0; i<ArrayCount(SpawnShooterDie); i++)
	{
		if(SpawnShooterDie[i]!="")
		{
			mysound=sound(DynamicLoadObject(SpawnShooterDie[i],class'Sound',false));
			if(mysound==none)
				log("## BFF - Error Loading Sound"$SpawnShooterDie[i]);
			else
			{
				sndSpawnShooterDie[i]=mysound;
				j++;
			}
		}
	}

	if(SpawnSound!="")
	{
		mysound=sound(DynamicLoadObject(SpawnSound,class'Sound',false));
		if(mysound==none)
			log("## BFF - Error Loading Sound"$SpawnSound);
		else
			sndSpawnSound=mysound;
	}
}

//Consider leaving out all default properties
defaultproperties
{
	bHidden=True
}
